/*
 * COPYRIGHT (c) 2010 by Institute of Computer Science, 
 * Foundation for Research and Technology - Hellas
 * Contact: 
 *      POBox 1385, Heraklio Crete, GR-700 13 GREECE
 *      Tel:+30-2810-391632
 *      Fax: +30-2810-391638
 *      E-mail: isl@ics.forth.gr
 *      http://www.ics.forth.gr/isl/cci.html
 * 
 * This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 
 * Unported License (http://creativecommons.org/licenses/by-sa/3.0/)
*/

package Transformation;

import java.util.ArrayList;

/**
 * Describes an ObjectClass object which is the object in CIDOC triples.
 * @author Koutraki Maria (kutraki@ics.forth.gr)
 */
public class ObjectClass {

    private String entity;
    private String uriFunctionName;	
    private ArrayList uriFunctionArguments; /*uriFunctionArguments is a list of arguments for the URI functions. */
    private String attribute;

    public ObjectClass(String entity, String uriFunctionName, ArrayList uriFunctionArguments, String attribute) {
        this.entity = entity;
        this.uriFunctionName = uriFunctionName;
        this.uriFunctionArguments = uriFunctionArguments;
        this.attribute = attribute;
    }

    public String getEntity() {
        return entity;
    }

    public String getUriFunctionName() {
        return uriFunctionName;
    }

    public ArrayList getUriFunctionArguments() {
        return uriFunctionArguments;
    }
    public String getAttribute(){
        return attribute;
    }
}
